<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-08-13 02:40
 */
interface ProgramsettingsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Programsettings 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param programsetting primary key
 	 */
	public function delete($programsettingsid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Programsettings programsetting
 	 */
	public function insert($programsetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Programsettings programsetting
 	 */
	public function update($programsetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompanyname($value);

	public function queryByAddress($value);

	public function queryByTopaddress($value);

	public function queryBySpecializtion($value);

	public function queryByPhone($value);

	public function queryByPhone2($value);

	public function queryByFaxnumber($value);

	public function queryByEmail($value);

	public function queryByWebsite($value);

	public function queryByLogo($value);

	public function queryByRoundnumbers($value);

	public function queryBySaveprinting($value);

	public function queryByDeptprinting($value);

	public function queryByPrintingpapersize($value);

	public function queryByUserid($value);

	public function queryByShowPreviousPrice($value);

	public function queryByParcode($value);

	public function queryByPriceing($value);

	public function queryByLastprice($value);

	public function queryBySearchvalue($value);

	public function queryByUpdateproductprice($value);

	public function queryByAllowfinsldelete($value);

	public function queryByUpdateclientprice($value);

	public function queryByPartition($value);

	public function queryByTaxcard($value);

	public function queryByCommercialregistration($value);

	public function queryByCostcenter($value);

	public function queryByCopytype($value);

	public function queryByUrlcopy($value);

	public function queryByInternalcopy($value);

	public function queryByClinic($value);

	public function queryByWorkshop($value);

	public function queryByTransport($value);

	public function queryByManufacturing($value);

	public function queryByMasterCopy($value);

	public function queryByDailyentrydate($value);

	public function queryByUpdatefiledate($value);

	public function queryByWorkerbetweenstores($value);

	public function queryByWorkshoptimeout($value);

	public function queryByDrivertimeout($value);

	public function queryByCurrancy($value);

	public function queryBySerial($value);

	public function queryByAllowdateedit($value);

	public function queryByClientcode($value);

	public function queryByClientserial($value);

	public function queryByTimezone($value);

	public function queryByExpiredate($value);

	public function queryByProduction($value);

	public function queryByDescription($value);

	public function queryByService($value);

	public function queryByDate($value);

	public function queryByLimitamount($value);

	public function queryByMeasuringunit($value);

	public function queryByPrintAmount($value);

	public function queryByBillid($value);

	public function queryByPrecentages($value);

	public function queryByRealprice($value);

	public function queryByDelegateSeller($value);

	public function queryByStoreserial($value);

	public function queryByClientcodname($value);

	public function queryByClientfieldrequired($value);

	public function queryByColortype($value);

	public function queryByNakdyOnly($value);

	public function queryByNakdyKashf($value);

	public function queryByDiscountPresDirect($value);

	public function queryByGeneralDiscount($value);

	public function queryBySellsReturn($value);

	public function queryByScunitname($value);

	public function queryByVatValue($value);

	public function queryBySyncstructure($value);

	public function queryByShowPrevPrices($value);

	public function queryByIsOpticProg($value);

	public function queryByReportsPlusHours($value);

	public function queryByShowM5zon($value);

	public function queryByRestaurantStoreId($value);

	public function queryByRestuarantPrintTimeout($value);

	public function queryBySumSameProductForStore($value);

	public function queryByEditAllPrice($value);

	public function queryByIsCafe($value);

	public function queryByIsRestaurent($value);

	public function queryByProductDays($value);

	public function queryByThereIsRestTax($value);

	public function queryByRestTaxVal($value);

	public function queryByRestPrintLang($value);

	public function queryByTaxNameFlag($value);

	public function queryByParcodeDigits($value);

	public function queryBySpecializedParcodeDigits($value);

	public function queryByClientDefaultDebtLimit($value);

	public function queryByClientDefaultDebtLimitControl($value);

	public function queryByUsedParcode($value);

	public function queryByProductbycodeimage($value);

	public function queryByCommentClient($value);

	public function queryByInventoryevaluation($value);

	public function queryByProfitevaluation($value);

	public function queryByDelivery($value);

	public function queryByPremiums($value);

	public function queryByOperationnumEdit($value);

	public function queryByNoOfDecimalPlaces($value);

	public function queryByUnReviewBills($value);

	public function queryByUnReviewBillsPass($value);

	public function queryByBillReviewNote($value);

	public function queryByTamweenBakery($value);

	public function queryByCopyRightsStatment($value);

	public function queryByThreeMonths($value);

	public function queryBySixMonths($value);

	public function queryByTwelveMonths($value);

	public function queryByEighteenMonths($value);

	public function queryByTwentyfourMonths($value);

	public function queryByThirtyMonths($value);

	public function queryBySixthirtyMonths($value);

	public function queryByFortytwoMonths($value);

	public function queryByFortyeightMonths($value);

	public function queryByRemoteBackupLink($value);

	public function queryByRemoteBackupUser($value);

	public function queryByRemoteBackupPass($value);

	public function queryByRemoteBackupFolder($value);

	public function queryByMandobCollectionRatio($value);

	public function queryByTakeAwayClient($value);

	public function queryByRestaurantServiceOn($value);

	public function queryByEarlyrepayment($value);

	public function queryByVisaPay($value);

	public function queryByHeaderPrint($value);

	public function queryByHeaderPrintSand($value);

	public function queryByPrintSand($value);

	public function queryByMakeDailyEntry($value);

	public function queryByClientShowTawla($value);

	public function queryByBillRest($value);

	public function queryBySuppIsClientToo($value);

	public function queryByIsCarBill($value);

	public function queryByExpensesproduct($value);


	public function deleteByCompanyname($value);

	public function deleteByAddress($value);

	public function deleteByTopaddress($value);

	public function deleteBySpecializtion($value);

	public function deleteByPhone($value);

	public function deleteByPhone2($value);

	public function deleteByFaxnumber($value);

	public function deleteByEmail($value);

	public function deleteByWebsite($value);

	public function deleteByLogo($value);

	public function deleteByRoundnumbers($value);

	public function deleteBySaveprinting($value);

	public function deleteByDeptprinting($value);

	public function deleteByPrintingpapersize($value);

	public function deleteByUserid($value);

	public function deleteByShowPreviousPrice($value);

	public function deleteByParcode($value);

	public function deleteByPriceing($value);

	public function deleteByLastprice($value);

	public function deleteBySearchvalue($value);

	public function deleteByUpdateproductprice($value);

	public function deleteByAllowfinsldelete($value);

	public function deleteByUpdateclientprice($value);

	public function deleteByPartition($value);

	public function deleteByTaxcard($value);

	public function deleteByCommercialregistration($value);

	public function deleteByCostcenter($value);

	public function deleteByCopytype($value);

	public function deleteByUrlcopy($value);

	public function deleteByInternalcopy($value);

	public function deleteByClinic($value);

	public function deleteByWorkshop($value);

	public function deleteByTransport($value);

	public function deleteByManufacturing($value);

	public function deleteByMasterCopy($value);

	public function deleteByDailyentrydate($value);

	public function deleteByUpdatefiledate($value);

	public function deleteByWorkerbetweenstores($value);

	public function deleteByWorkshoptimeout($value);

	public function deleteByDrivertimeout($value);

	public function deleteByCurrancy($value);

	public function deleteBySerial($value);

	public function deleteByAllowdateedit($value);

	public function deleteByClientcode($value);

	public function deleteByClientserial($value);

	public function deleteByTimezone($value);

	public function deleteByExpiredate($value);

	public function deleteByProduction($value);

	public function deleteByDescription($value);

	public function deleteByService($value);

	public function deleteByDate($value);

	public function deleteByLimitamount($value);

	public function deleteByMeasuringunit($value);

	public function deleteByPrintAmount($value);

	public function deleteByBillid($value);

	public function deleteByPrecentages($value);

	public function deleteByRealprice($value);

	public function deleteByDelegateSeller($value);

	public function deleteByStoreserial($value);

	public function deleteByClientcodname($value);

	public function deleteByClientfieldrequired($value);

	public function deleteByColortype($value);

	public function deleteByNakdyOnly($value);

	public function deleteByNakdyKashf($value);

	public function deleteByDiscountPresDirect($value);

	public function deleteByGeneralDiscount($value);

	public function deleteBySellsReturn($value);

	public function deleteByScunitname($value);

	public function deleteByVatValue($value);

	public function deleteBySyncstructure($value);

	public function deleteByShowPrevPrices($value);

	public function deleteByIsOpticProg($value);

	public function deleteByReportsPlusHours($value);

	public function deleteByShowM5zon($value);

	public function deleteByRestaurantStoreId($value);

	public function deleteByRestuarantPrintTimeout($value);

	public function deleteBySumSameProductForStore($value);

	public function deleteByEditAllPrice($value);

	public function deleteByIsCafe($value);

	public function deleteByIsRestaurent($value);

	public function deleteByProductDays($value);

	public function deleteByThereIsRestTax($value);

	public function deleteByRestTaxVal($value);

	public function deleteByRestPrintLang($value);

	public function deleteByTaxNameFlag($value);

	public function deleteByParcodeDigits($value);

	public function deleteBySpecializedParcodeDigits($value);

	public function deleteByClientDefaultDebtLimit($value);

	public function deleteByClientDefaultDebtLimitControl($value);

	public function deleteByUsedParcode($value);

	public function deleteByProductbycodeimage($value);

	public function deleteByCommentClient($value);

	public function deleteByInventoryevaluation($value);

	public function deleteByProfitevaluation($value);

	public function deleteByDelivery($value);

	public function deleteByPremiums($value);

	public function deleteByOperationnumEdit($value);

	public function deleteByNoOfDecimalPlaces($value);

	public function deleteByUnReviewBills($value);

	public function deleteByUnReviewBillsPass($value);

	public function deleteByBillReviewNote($value);

	public function deleteByTamweenBakery($value);

	public function deleteByCopyRightsStatment($value);

	public function deleteByThreeMonths($value);

	public function deleteBySixMonths($value);

	public function deleteByTwelveMonths($value);

	public function deleteByEighteenMonths($value);

	public function deleteByTwentyfourMonths($value);

	public function deleteByThirtyMonths($value);

	public function deleteBySixthirtyMonths($value);

	public function deleteByFortytwoMonths($value);

	public function deleteByFortyeightMonths($value);

	public function deleteByRemoteBackupLink($value);

	public function deleteByRemoteBackupUser($value);

	public function deleteByRemoteBackupPass($value);

	public function deleteByRemoteBackupFolder($value);

	public function deleteByMandobCollectionRatio($value);

	public function deleteByTakeAwayClient($value);

	public function deleteByRestaurantServiceOn($value);

	public function deleteByEarlyrepayment($value);

	public function deleteByVisaPay($value);

	public function deleteByHeaderPrint($value);

	public function deleteByHeaderPrintSand($value);

	public function deleteByPrintSand($value);

	public function deleteByMakeDailyEntry($value);

	public function deleteByClientShowTawla($value);

	public function deleteByBillRest($value);

	public function deleteBySuppIsClientToo($value);

	public function deleteByIsCarBill($value);

	public function deleteByExpensesproduct($value);


}
?>